-- ===================================================================================
-- ================Modificacion de la vista para mostrar las ventas===================
-- ===================================================================================
ALTER VIEW `view_sales` AS
select
    `tec_sales`.`id` AS `pid`,
    `tec_sales`.`date` AS `date`,
    `tec_sales`.`customer_name` AS `customer_name`,
    `tec_sales`.`currency` AS `currency`,
    `tec_sales`.`grand_total` AS `grand_total`,
    `tec_sales`.`paid` AS `paid`,
    `tec_sales`.`status` AS `status`,
case
        when `tec_sales`.`document_type` = 1 then 'Boleta'
        when `tec_sales`.`document_type` = 2 then 'Factura'
        else 'Nota de venta'
    end AS `vdoctype`,
    `tec_sales`.`invoice_id` AS `ndoc`,
    `tec_sales`.`estado` AS `estado`,
    `tec_canals`.`canal` AS `canal`,
    if(
        `t2`.`estadoSend` = 1,
        'Error de envío',
        if(
            `t2`.`estadoSend` = 2,
            'Enviado',
            if(
                `t2`.`estadoSend` = 3,
                concat(
                    'Rechazado|',
                    concat_ws(' ', `t2`.`error_code`, `t2`.`response_descrip`)
                ),
                if(`t2`.`estadoSend` = 4, 'Procesado', '')
            )
        )
    ) AS `Name_exp_12`,
    `tec_locals`.`code` AS `code`,
    `tec_sales`.`created_by` AS `created_by`,
    `t2`.`response_descrip` AS `response_descrip`
from
    (
        (
            (
                `tec_sales`
                left join `tec_canals` on(
                    `tec_canals`.`id` = `tec_sales`.`canal_id`
                )
            )
            left join `tec_locals` on(
                `tec_locals`.`id` = `tec_sales`.`local_id`
            )
        )
        left join (
            select
                `detalle`.`sale_id` AS `id_venta`,
                `envio`.`status` AS `estadoSend`,
                `envio`.`response_descrip` AS `response_descrip`,
                `envio`.`error_code` AS `error_code`
            from
                (
                    `tec_send_invoice` `envio`
                    join `tec_send_invoice_items` `detalle` on(`detalle`.`send_invoice_id` = `envio`.`id`)
                )
            where
                `envio`.`estado` = 1
        ) `t2` on(`t2`.`id_venta` = `tec_sales`.`id`)
    )
order by
    `tec_sales`.`date` desc
-- ===================================================================================
-- ================Script para actualizar la version del sistema======================
-- ===================================================================================

UPDATE tec_settings set version='2.5.7';